package demo;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import lrs.*;
import lrs.visitor.*;
import counter.*;
import lrs.lazyLRSEvaluators.*;
import logic.*;


public class LazyLRSDemoFrame extends JFrame {
  GridLayout gridLayout1 = new GridLayout();
  JTextArea textArea1 = new JTextArea();
  JPanel algoPnl = new JPanel();
  JLabel displayLenLbl = new JLabel();
  JLabel ioALbl = new JLabel();
  JLabel ioBLbl = new JLabel();
  JTextField ioATF = new JTextField();
  JTextField ioBTF = new JTextField();
  JTextField displayLenTF = new JTextField();
  JPanel ctrlPnl = new JPanel();
  JPanel displayLenIOABPnl = new JPanel();
  JPanel displayLenPnl = new JPanel();
  JPanel ioAPnl = new JPanel();
  JPanel ioBPnl = new JPanel();
  JPanel displayLenIOABCtrlPnl = new JPanel();
  JRadioButton chkBxConst = new JRadioButton();
  JRadioButton chkBxInc = new JRadioButton();
  JRadioButton chkBxFibonacci = new JRadioButton();
  JRadioButton chkBxFilter = new JRadioButton();
  JRadioButton chkBxRangeFilter = new JRadioButton();
  JRadioButton chkBxMultMNodFilter = new JRadioButton();
  JRadioButton chkBxSieve = new JRadioButton();
  JRadioButton chkBxNInv = new JRadioButton();
  JRadioButton chkBxLambda = new JRadioButton();
  ButtonGroup buttonGroup = new ButtonGroup();
  JButton diffLambdaBtn = new JButton("Differentiate Lambda");
  
  LRStruct list = new LRStruct();
  ICounterFactory cf = CounterFactory.Singleton;
  
  JScrollPane jScrollPane1 = new JScrollPane();
  JButton selSortBtn = new JButton();
  JButton selSortBtn1 = new JButton();
  JButton nthCdrBtn = new JButton();
  JButton trimBtn = new JButton();
  JButton btnSetNth = new JButton();
  JButton btnRemNth = new JButton();
  JButton btnNth = new JButton();
  JButton sumBtn = new JButton();
  JButton sumNBtn = new JButton();
  JButton sumLambdaNBtn = new JButton();
  JButton appendBtn = new JButton();
  JButton getLastBtn = new JButton();
  JButton removeBtn = new JButton();
  JButton ordInsertBtn = new JButton();
  JButton consBtn = new JButton();
  JButton clearBtn = new JButton();
  GridLayout gridLayout5 = new GridLayout();
  GridLayout gridLayout6 = new GridLayout();
  GridLayout gridLayout7 = new GridLayout();
  GridLayout gridLayout8 = new GridLayout();
  BorderLayout borderLayout1 = new BorderLayout();
  BorderLayout borderLayout2 = new BorderLayout();
  BorderLayout borderLayout3 = new BorderLayout();
  
  //Construct the frame
  public LazyLRSDemoFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try  {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });
    
    buttonGroup.add(chkBxConst);
    buttonGroup.add(chkBxInc);
    buttonGroup.add(chkBxFibonacci);
    buttonGroup.add(chkBxFilter);
    buttonGroup.add(chkBxRangeFilter);
    buttonGroup.add(chkBxMultMNodFilter);
    buttonGroup.add(chkBxSieve);
    buttonGroup.add(chkBxNInv);
    buttonGroup.add(chkBxLambda);
    validate();
    pack();
  }
  
  //Component initialization
  private void jbInit() throws Exception  {
    gridLayout1.setColumns(3);
    gridLayout1.setHgap(2);
    gridLayout1.setVgap(2);
    this.getContentPane().setLayout(gridLayout1);
   // this.setSize(new Dimension(810, 737));
    this.setTitle("Lazy Evaluation of LRStructs");
    
    displayLenLbl.setFont(new java.awt.Font("Dialog", 1, 18));
    displayLenLbl.setHorizontalAlignment(SwingConstants.LEFT);
    displayLenLbl.setLabelFor(displayLenTF);
    displayLenLbl.setText("Display length:");
  
    ioALbl.setFont(new java.awt.Font("Dialog", 1, 18));
    ioALbl.setHorizontalAlignment(SwingConstants.LEFT);
    ioALbl.setText("Input/Output A:");
    
    ioBLbl.setFont(new java.awt.Font("Dialog", 1, 18));
    ioBLbl.setHorizontalAlignment(SwingConstants.LEFT);
    ioBLbl.setText("Input/Output B:");
    
    ioATF.setColumns(6);
    ioATF.setHorizontalAlignment(SwingConstants.CENTER);
    ioATF.setBackground(Color.lightGray);
    ioATF.setFont(new java.awt.Font("SansSerif", 1, 20));
    ioATF.setBorder(null);
    ioATF.setOpaque(false);
    ioATF.setText("1");    
    
    ioBTF.setFont(new java.awt.Font("SansSerif", 1, 20));
    ioBTF.setColumns(6);
    ioBTF.setBorder(null);
    ioBTF.setOpaque(false);
    ioBTF.setText("1");
    ioBTF.setHorizontalAlignment(SwingConstants.CENTER);
    
    displayLenTF.setBackground(Color.lightGray);
    displayLenTF.setFont(new java.awt.Font("Dialog", 1, 20));
    displayLenTF.setBorder(null);
    displayLenTF.setOpaque(false);
    displayLenTF.setPreferredSize(new Dimension(102, 27));
    displayLenTF.setText("15");
    displayLenTF.setHorizontalAlignment(SwingConstants.CENTER);
    displayLenTF.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        displayLenTF_actionPerformed(e);
      }
    });
    ctrlPnl.setLayout(gridLayout6);
    ctrlPnl.setBackground(Color.cyan);
    //ctrlPnl.setPreferredSize(new Dimension(227, 500));
    displayLenIOABPnl.setLayout(gridLayout7);
    displayLenPnl.setLayout(borderLayout2);
    ioAPnl.setLayout(borderLayout1);
    ioBPnl.setLayout(borderLayout3);
    displayLenIOABCtrlPnl.setLayout(gridLayout8);
    chkBxConst.setToolTipText("value <- A");
    chkBxConst.setOpaque(false);
    chkBxConst.setText("Constant List");
    chkBxConst.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxConst.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxConst_actionPerformed(e);
      }
    });
    chkBxInc.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxInc_actionPerformed(e);
      }
    });
    chkBxInc.setText("Arithmetic List");
    chkBxInc.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxInc.setToolTipText("x0 <- A, inc <- B");
    chkBxInc.setOpaque(false);
    chkBxFibonacci.setOpaque(false);
    chkBxFibonacci.setText("Fibonacci List");
    chkBxFibonacci.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxFibonacci.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxFibonacci_actionPerformed(e);
      }
    });
    chkBxFilter.setToolTipText("value <- A");
    chkBxFilter.setOpaque(false);
    chkBxFilter.setText("Modulo Filter");
    chkBxFilter.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxFilter.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxFilter_actionPerformed(e);
      }
    });
    chkBxRangeFilter.setToolTipText("min <- A, max <- B");
    chkBxRangeFilter.setOpaque(false);
    chkBxRangeFilter.setText("Range Filtered List");
    chkBxRangeFilter.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxRangeFilter.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxRangeFilter_actionPerformed(e);
      }
    });
    chkBxMultMNodFilter.setToolTipText("value 1 <- A, value 2 <- B");
    chkBxMultMNodFilter.setOpaque(false);
    chkBxMultMNodFilter.setText("Multiple Modulo Filtered List");
    chkBxMultMNodFilter.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxMultMNodFilter.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxMultMNodFilter_actionPerformed(e);
      }
    });
    chkBxSieve.setOpaque(false);
    chkBxSieve.setText("Prime Numbers List");
    chkBxSieve.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxSieve.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxSieve_actionPerformed(e);
      }
    });
    
    chkBxNInv.setOpaque(false);
    chkBxNInv.setText("1/N! list");
    chkBxNInv.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxNInv.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxNInv_actionPerformed(e);
      }
    });

    chkBxLambda.setOpaque(false);
    chkBxLambda.setText("Lambda list");
    chkBxLambda.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxLambda.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        chkBxLambda_actionPerformed(e);
      }
    });
    
    diffLambdaBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        diffLambdaBtn_actionPerformed(e);
      }
    });
    
    
    textArea1.setMargin(new Insets(10, 50, 10, 10));
    textArea1.setEditable(false);
    textArea1.setFont(new java.awt.Font("Serif", 1, 30));
    selSortBtn.setBackground(Color.yellow);
    selSortBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    selSortBtn.setText("Selection Sort  <");
    selSortBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        selSortBtn_actionPerformed(e);
      }
    });
    algoPnl.setLayout(gridLayout5);
    algoPnl.setBackground(new java.awt.Color(135, 104, 151));
    selSortBtn1.setText("Selection Sort  >");
    selSortBtn1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        selSortBtn1_actionPerformed(e);
      }
    });
    selSortBtn1.setFont(new java.awt.Font("Dialog", 1, 18));
    selSortBtn1.setBackground(Color.yellow);
    nthCdrBtn.setText("n\'th Cdr");
    nthCdrBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        nthCdrBtn_actionPerformed(e);
      }
    });
    nthCdrBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    nthCdrBtn.setToolTipText("n <- A");
    nthCdrBtn.setBackground(Color.yellow);
    trimBtn.setText("Trim at n\'th");
    trimBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        trimBtn_actionPerformed(e);
      }
    });
    trimBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    trimBtn.setToolTipText("n <- A");
    trimBtn.setBackground(Color.yellow);
    btnSetNth.setText("Set n\'th");
    btnSetNth.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        btnSetNth_actionPerformed(e);
      }
    });
    btnSetNth.setFont(new java.awt.Font("Dialog", 1, 18));
    btnSetNth.setToolTipText("n <- A, value <- B");
    btnSetNth.setBackground(Color.yellow);
    btnRemNth.setText("Remove n\'th");
    btnRemNth.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        btnRemNth_actionPerformed(e);
      }
    });
    btnRemNth.setFont(new java.awt.Font("Dialog", 1, 18));
    btnRemNth.setToolTipText("n <- A, B <- value");
    btnRemNth.setBackground(Color.yellow);
    btnNth.setText("n\'th Element");
    btnNth.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        btnNth_actionPerformed(e);
      }
    });
    btnNth.setFont(new java.awt.Font("Dialog", 1, 18));
    btnNth.setToolTipText("n <- A,  B <- value");
    btnNth.setBackground(Color.yellow);
    sumBtn.setText("Sum");
    sumBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        sumBtn_actionPerformed(e);
      }
    });
    sumBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    sumBtn.setToolTipText("A <- sum");
    sumBtn.setBackground(Color.yellow);

    sumNBtn.setText("Sum N terms");
    sumNBtn.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent e)
      {
        sumNBtn_actionPerformed(e);
      }
    });
    
    sumNBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    sumNBtn.setToolTipText("A = N, B <- sum");
    sumNBtn.setBackground(Color.yellow);
    
    sumLambdaNBtn.setText("Sum N Lamba terms");
    sumLambdaNBtn.addActionListener(new java.awt.event.ActionListener(){
      public void actionPerformed(ActionEvent e)
      {
        sumLambdaNBtn_actionPerformed(e);
      }
    });
    
    sumLambdaNBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    sumLambdaNBtn.setToolTipText("A = N, B = 0<x<1, B <- sum");
    sumLambdaNBtn.setBackground(Color.yellow);
    
    appendBtn.setText("Append");
    appendBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        appendBtn_actionPerformed(e);
      }
    });
    appendBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    appendBtn.setToolTipText("value <- A");
    appendBtn.setBackground(Color.yellow);
    getLastBtn.setText("Get Last");
    getLastBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e)
      {
        getLastBtn_actionPerformed(e);
      }
    });
    getLastBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    getLastBtn.setToolTipText("A <- value");
    getLastBtn.setBackground(Color.yellow);
    removeBtn.setText("Remove Car");
    removeBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        removeBtn_actionPerformed(e);
      }
    });
    removeBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    removeBtn.setToolTipText("A <- value");
    removeBtn.setBackground(Color.yellow);
    ordInsertBtn.setText("Ordered Insert +");
    ordInsertBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        ordInsertBtn_actionPerformed(e);
      }
    });
    ordInsertBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    ordInsertBtn.setToolTipText("value <- A");
    ordInsertBtn.setBackground(Color.yellow);
    consBtn.setText("Cons");
    consBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        consBtn_actionPerformed(e);
      }
    });
    consBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    consBtn.setToolTipText("car <- A ");
    consBtn.setBackground(Color.yellow);
    clearBtn.setText("Clear");
    clearBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        clearBtn_actionPerformed(e);
      }
    });
    clearBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    clearBtn.setBackground(Color.yellow);
    gridLayout5.setColumns(1);
    gridLayout5.setHgap(2);
    gridLayout5.setRows(0);
    gridLayout5.setVgap(2);
    gridLayout6.setColumns(1);
    gridLayout6.setHgap(2);
    gridLayout6.setRows(0);
    gridLayout6.setVgap(2);
    gridLayout7.setColumns(1);
    gridLayout7.setHgap(2);
    gridLayout7.setRows(0);
    gridLayout7.setVgap(2);
    gridLayout8.setColumns(1);
    gridLayout8.setHgap(2);
    gridLayout8.setRows(0);
    gridLayout8.setVgap(2);
    displayLenIOABPnl.setBackground(Color.white);
    displayLenPnl.setBorder(BorderFactory.createRaisedBevelBorder());
    ioAPnl.setBorder(BorderFactory.createRaisedBevelBorder());
    ioBPnl.setBorder(BorderFactory.createRaisedBevelBorder());
    this.getContentPane().add(displayLenIOABCtrlPnl, null);
    displayLenIOABCtrlPnl.add(displayLenIOABPnl, null);
    displayLenIOABPnl.add(displayLenPnl, null);
    displayLenPnl.add(displayLenLbl, BorderLayout.CENTER);
    displayLenPnl.add(displayLenTF, BorderLayout.EAST);
    displayLenIOABPnl.add(ioAPnl, null);
    ioAPnl.add(ioALbl, BorderLayout.WEST);
    ioAPnl.add(ioATF, BorderLayout.CENTER);
    displayLenIOABPnl.add(ioBPnl, null);
    ioBPnl.add(ioBLbl, BorderLayout.WEST);
    ioBPnl.add(ioBTF, BorderLayout.CENTER);
    displayLenIOABCtrlPnl.add(ctrlPnl, null);
    ctrlPnl.add(chkBxConst, null);
    ctrlPnl.add(chkBxInc, null);
    ctrlPnl.add(chkBxFilter, null);
    ctrlPnl.add(chkBxFibonacci, null);
    ctrlPnl.add(chkBxRangeFilter, null);
    ctrlPnl.add(chkBxMultMNodFilter, null);
    ctrlPnl.add(chkBxSieve, null);
    ctrlPnl.add(chkBxNInv, null);
    ctrlPnl.add(chkBxLambda, null);
    ctrlPnl.add(diffLambdaBtn, null);

    this.getContentPane().add(algoPnl, null);
    algoPnl.add(clearBtn, null);
    algoPnl.add(consBtn, null);
    algoPnl.add(ordInsertBtn, null);
    algoPnl.add(removeBtn, null);
    algoPnl.add(getLastBtn, null);
    algoPnl.add(appendBtn, null);
    algoPnl.add(sumBtn, null);
    algoPnl.add(sumNBtn, null);
    algoPnl.add(sumLambdaNBtn, null);
    algoPnl.add(btnNth, null);
    algoPnl.add(btnRemNth, null);
    algoPnl.add(btnSetNth, null);
    algoPnl.add(trimBtn, null);
    algoPnl.add(nthCdrBtn, null);
    algoPnl.add(selSortBtn1, null);
    algoPnl.add(selSortBtn, null);
    this.getContentPane().add(jScrollPane1, null);
    jScrollPane1.getViewport().add(textArea1, null);
  }
  
  
  void displayLenTF_actionPerformed(ActionEvent e) {
    printList();
  }
  
  void chkBxConst_actionPerformed(ActionEvent e) {
    list = new LazyConstantEval (Integer.parseInt(ioATF.getText())).makeLRS ();
    printList ();
  }
  
  void chkBxInc_actionPerformed(ActionEvent e) {
    list = new LazyIncEval (Integer.parseInt(ioATF.getText()),
                            Integer.parseInt(ioBTF.getText())).makeLRS ();
    printList ();
  }
  
  void chkBxFibonacci_actionPerformed(ActionEvent e) {
    list =  (new LazyFibEval(0, 1)).makeLRS();
    printList();
  }
  
  void chkBxFilter_actionPerformed(ActionEvent e){
    list = new LazyFilterEval (new ModPredStrategy(Integer.parseInt (ioATF.getText ())), list).makeLRS ();
    printList ();
  }
  
  void chkBxRangeFilter_actionPerformed(ActionEvent e) {
    list = new LazyFilterEval (new RangePredicate(
                                                  Integer.parseInt (ioATF.getText ()),
                                                  Integer.parseInt (ioBTF.getText ())),
                               list).makeLRS ();
    printList ();
  }
  
  void chkBxMultMNodFilter_actionPerformed(ActionEvent e) {
    list = new LazyFilterEval (new MultModPredicate(Integer.parseInt (ioATF.getText ()),
                                                    Integer.parseInt (ioBTF.getText ())),
                               list).makeLRS ();
    printList ();
  }
  
  void chkBxSieve_actionPerformed(ActionEvent e) {
    list =  (new LazySieveEval()).makeLRS();
    printList();
  }
  
  void chkBxNInv_actionPerformed(ActionEvent e) {
    list =  (new LazyNFacInvEval()).makeLRS();
    printList();
  }

  void chkBxLambda_actionPerformed(ActionEvent e) {
    list =  (new LazyLambdaEval()).makeLRS();
    printList();
  }
  
  void printList(){
    textArea1.setText("");
    list.execute(new LRSPrintN(textArea1), cf.makeCounter(Integer.parseInt(displayLenTF.getText())));
    validate();
    pack();   
  }
  
  void clearBtn_actionPerformed(ActionEvent e) {
    list.execute(LRSClear.Singleton);
    printList();  
  }
  
  void consBtn_actionPerformed(ActionEvent e) {
    list.insertFront(new Integer(ioATF.getText()));
    printList();
  }
  
  void ordInsertBtn_actionPerformed(ActionEvent e){
    list.execute( LRSOrderedInsert.Singleton, new Integer(ioATF.getText()));
    printList();
  }
  
  void removeBtn_actionPerformed(ActionEvent e) {
    ioATF.setText(((Integer)list.removeFront()).toString());
    printList();
  }
  
  void getLastBtn_actionPerformed(ActionEvent e) {
    ioATF.setText(((Integer)list.execute(GetLast.Singleton,list)).toString());
  }
  
  void appendBtn_actionPerformed(ActionEvent e) {
    list.execute( LRSAppend.Singleton, new Integer(ioATF.getText()));
    printList();
  }
  
  void sumBtn_actionPerformed(ActionEvent e) {
    ioATF.setText(((Integer) list.execute(LRSSum.Singleton)).toString());
  }
  
  void sumNBtn_actionPerformed(ActionEvent e) {
    ioBTF.setText(list.execute(LRSSumN.Singleton,
                               cf.makeCounter(Integer.parseInt(ioATF.getText()))).toString());
  }
  
  void sumLambdaNBtn_actionPerformed(ActionEvent e) {
    ioBTF.setText(list.execute(LRSSumLambdaN.Singleton,
                               cf.makeCounter(Integer.parseInt(ioATF.getText())),
                               Double.parseDouble(ioBTF.getText())).toString());
  }

  void btnNth_actionPerformed(ActionEvent e) {
    ioBTF.setText(list.execute(Nth.Singleton, 
                               cf.makeCounter(Integer.parseInt(ioATF.getText()))).toString());
  }
  
  void btnRemNth_actionPerformed(ActionEvent e) {
    ioBTF.setText(list.execute(RemoveNth.Singleton, 
                               cf.makeCounter(Integer.parseInt(ioATF.getText ()))).toString());
    printList ();
  }
  
  void btnSetNth_actionPerformed(ActionEvent e){
    int ix = Integer.parseInt (ioATF.getText ());
    Integer dat = Integer.parseInt (ioBTF.getText ());
    list.execute(SetNth.Singleton, cf.makeCounter(ix), dat);
    printList ();
  }
  
  void trimBtn_actionPerformed(ActionEvent e) {
    list.execute(LRSTrim.Singleton, 
                 cf.makeCounter(Integer.parseInt(ioATF.getText())));
    printList();
  }
  
  void nthCdrBtn_actionPerformed(ActionEvent e){
    list = (LRStruct) list.execute(NthCdr.Singleton, 
                                   cf.makeCounter(Integer.parseInt(ioATF.getText())));
    printList();
  }
  
  void selSortBtn1_actionPerformed(ActionEvent e){
    list.execute(new SelectionSort(GetMax.Singleton));
    printList();
  }
  
  void selSortBtn_actionPerformed(ActionEvent e){
    list.execute(new SelectionSort(GetMin.Singleton));
    printList();
  }  

  void diffLambdaBtn_actionPerformed(ActionEvent e){
    list =  (new LazyDiffLambdaEval(list)).makeLRS();
    printList();
  }  
  
}
